/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.config.MutantMoreGroupedOptionsCommonConfig;
import com.alexander.mutantmore.entities.MutantBlaze;
import com.alexander.mutantmore.entities.MutantBlazeShieldPart;
import com.alexander.mutantmore.entities.Rodling;
import com.alexander.mutantmore.init.DamageSourceInit;
import com.alexander.mutantmore.init.EntityTypeInit;
import com.alexander.mutantmore.init.SoundEventInit;
import com.alexander.mutantmore.init.TagInit;
import com.alexander.mutantmore.util.MiscUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MutantBlazeRodProjectile
extends ThrowableProjectile
implements IAnimatable {
    private static final EntityDataAccessor<Boolean> BROKEN_BLOCK = SynchedEntityData.m_135353_(MutantBlazeRodProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RODLING = SynchedEntityData.m_135353_(MutantBlazeRodProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHIELDS = SynchedEntityData.m_135353_(MutantBlazeRodProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ARMOUR = SynchedEntityData.m_135353_(MutantBlazeRodProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> COLLECTABLE = SynchedEntityData.m_135353_(MutantBlazeRodProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int despawnTimer;
    public boolean summonedRodling = false;
    public boolean landed = false;
    public float damage = 0.0f;
    public int fireLength = 0;
    public boolean ignoresInvulTime = true;
    public int despawnTime = 1200;
    public boolean glows = false;
    public boolean griefing = true;
    public boolean griefingDropsBlocks = false;
    public boolean fireGriefing = false;

    public MutantBlazeRodProjectile(EntityType<? extends MutantBlazeRodProjectile> p_37391_, Level p_37392_) {
        super(p_37391_, p_37392_);
    }

    public MutantBlazeRodProjectile(Level p_37399_, LivingEntity p_37400_) {
        super((EntityType)EntityTypeInit.MUTANT_BLAZE_ROD_PROJECTILE.get(), p_37400_, p_37399_);
    }

    public MutantBlazeRodProjectile(Level p_37394_, double p_37395_, double p_37396_, double p_37397_) {
        super((EntityType)EntityTypeInit.MUTANT_BLAZE_ROD_PROJECTILE.get(), p_37395_, p_37396_, p_37397_, p_37394_);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isRodling()) {
            if (this.isCollectable() && this.landed) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("rodling_sitting", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("rodling_projectile", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean m_142038_() {
        return this.isCollectable() && (this.glows || (Boolean)MutantMoreGroupedOptionsCommonConfig.mutant_parts_glow_on.get() != false);
    }

    public InteractionResult m_6096_(Player p_19978_, InteractionHand p_19979_) {
        if (this.isCollectable()) {
            if (this.isRodling()) {
                this.becomeRodling(p_19978_);
                return InteractionResult.SUCCESS;
            }
            if (!this.f_19853_.f_46443_) {
                this.m_19998_((ItemLike)Items.f_42593_);
                this.m_146870_();
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(p_19978_, p_19979_);
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20077_() && this.isCollectable()) {
            this.m_20334_(0.0, 0.05, 0.0);
        }
        HitResult hitresult = ProjectileUtil.m_37294_((Entity)this, this::m_5603_);
        if (!this.f_19794_) {
            this.m_6532_(hitresult);
            this.f_19812_ = true;
        }
        if (this.isCollectable()) {
            if (!this.f_19853_.f_46443_ && ++this.despawnTimer >= 6000) {
                this.m_146870_();
            }
        } else if (!this.f_19853_.f_46443_ && ++this.despawnTimer >= 1200) {
            this.m_146870_();
        }
    }

    protected boolean m_5603_(Entity target) {
        return this.canHit(target) && super.m_5603_(target);
    }

    protected void m_5790_(EntityHitResult p_37404_) {
        super.m_5790_(p_37404_);
        Entity entity = p_37404_.m_82443_();
        if (this.canHarm(entity) && !this.landed) {
            if (entity instanceof LivingEntity && ((LivingEntity)entity).m_21254_()) {
                entity.m_6469_(DamageSourceInit.mutantBlazeRodProjectile((Entity)this, this.m_37282_()), this.damage);
                this.m_20256_(this.m_20184_().m_82542_(-0.25, 0.5, -0.25));
            } else {
                if (this.ignoresInvulTime) {
                    entity.f_19802_ = 0;
                }
                entity.m_6469_(DamageSourceInit.mutantBlazeRodProjectile((Entity)this, this.m_37282_()), this.damage);
                entity.m_20254_(this.fireLength);
                if (this.isRodling()) {
                    this.m_20256_(this.m_20184_().m_82542_(-0.25, 0.5, -0.25));
                } else if (!this.f_19853_.f_46443_ && !this.isCollectable()) {
                    this.m_146870_();
                }
            }
        }
    }

    boolean canHarm(Entity target) {
        if (MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_BLAZE_ROD_PROJECTILE_CANT_HURT, (Entity)this, target, this.m_37282_(), entity -> entity instanceof MutantBlaze)) {
            return true;
        }
        return MiscUtils.canHarmBasedOnTeamAndTag(null, (Entity)this, target, this.m_37282_(), entity -> !(entity instanceof MutantBlaze));
    }

    boolean canHit(Entity target) {
        if (MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_BLAZE_ROD_PROJECTILE_CANT_HIT, (Entity)this, target, this.m_37282_(), entity -> entity instanceof MutantBlaze)) {
            return true;
        }
        return MiscUtils.canHarmBasedOnTeamAndTag(null, (Entity)this, target, this.m_37282_(), entity -> !(entity instanceof MutantBlaze));
    }

    protected void m_8060_(BlockHitResult p_37258_) {
        super.m_8060_(p_37258_);
        BlockPos blockpos = p_37258_.m_82425_();
        if (!this.hasBrokenBlock()) {
            this.setHasBrokenBlock(true);
            this.m_20256_(this.m_20184_().m_82542_(-0.25, 0.5, -0.25));
            if (!this.f_19853_.f_46443_ && this.griefing && !this.isCollectable() && !this.f_19853_.m_8055_(blockpos).m_204336_(TagInit.Blocks.UNBREAKABLE)) {
                this.f_19853_.m_46961_(blockpos, this.griefingDropsBlocks);
            }
        } else if (this.isRodling() && !this.isCollectable()) {
            if (!this.summonedRodling) {
                this.becomeRodling(null);
            }
        } else {
            this.f_19853_.m_8055_(blockpos).m_60682_(this.f_19853_, blockpos, (Entity)this);
            this.landed = true;
            this.m_20334_(0.0, 0.0, 0.0);
            if (this.f_19853_.m_8055_(this.m_20183_()).m_60795_() && this.fireGriefing && !this.f_19853_.f_46443_ && !this.isCollectable()) {
                this.f_19853_.m_46597_(this.m_20183_(), BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)blockpos));
            }
        }
        if (!(this.f_19853_.f_46443_ || this.isCollectable() || this.isRodling())) {
            this.m_146870_();
        }
    }

    public void becomeRodling(Player possibleNewOwner) {
        if (!this.f_19853_.f_46443_) {
            this.summonedRodling = true;
            ServerLevel serverlevel = (ServerLevel)this.f_19853_;
            Rodling rodling = (Rodling)((EntityType)EntityTypeInit.RODLING.get()).m_20615_(this.f_19853_);
            rodling.m_20219_(this.m_20182_());
            rodling.m_6518_((ServerLevelAccessor)serverlevel, this.f_19853_.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            if (this.hasArmour()) {
                rodling.setArmoured(true);
            }
            if (this.hasShields()) {
                rodling.setHasShields(true);
            }
            if (this.m_37282_() != null && this.m_37282_() instanceof Mob && ((Mob)this.m_37282_()).m_5448_() != null) {
                rodling.m_6710_(((Mob)this.m_37282_()).m_5448_());
            }
            if (this.m_37282_() != null && this.m_37282_().m_5647_() != null && possibleNewOwner == null) {
                Scoreboard scoreboard = this.f_19853_.m_6188_();
                scoreboard.m_6546_(rodling.m_6302_(), scoreboard.m_83489_(this.m_37282_().m_5647_().m_5758_()));
            }
            if (possibleNewOwner != null) {
                rodling.m_21828_(possibleNewOwner);
                rodling.m_21573_().m_26573_();
                rodling.m_6710_(null);
                rodling.setWantsToSit(true);
                rodling.f_19853_.m_7605_((Entity)rodling, (byte)7);
            }
            rodling.m_8032_();
            serverlevel.m_47205_((Entity)rodling);
            this.m_146870_();
        }
        if (possibleNewOwner != null) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
        }
    }

    protected void m_6532_(HitResult p_37406_) {
        if (!(p_37406_ instanceof EntityHitResult && ((EntityHitResult)p_37406_).m_82443_() instanceof MutantBlazeShieldPart && this.f_19797_ <= 10 || p_37406_ instanceof EntityHitResult && ((EntityHitResult)p_37406_).m_82443_() instanceof MutantBlazeRodProjectile)) {
            if (!this.landed && !this.hasBrokenBlock()) {
                this.m_5496_((SoundEvent)SoundEventInit.MUTANT_BLAZE_ROD_IMPACT.get(), 1.0f, MiscUtils.randomSoundPitch());
            }
            super.m_6532_(p_37406_);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BROKEN_BLOCK, (Object)false);
        this.f_19804_.m_135372_(RODLING, (Object)false);
        this.f_19804_.m_135372_(SHIELDS, (Object)false);
        this.f_19804_.m_135372_(ARMOUR, (Object)false);
        this.f_19804_.m_135372_(COLLECTABLE, (Object)false);
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("HasBrokenBlock", this.hasBrokenBlock());
        tag.m_128379_("IsRodling", this.isRodling());
        tag.m_128379_("HasShields", this.hasShields());
        tag.m_128379_("HasArmour", this.hasArmour());
        tag.m_128379_("Collectable", this.isCollectable());
        tag.m_128350_("Damage", this.damage);
        tag.m_128405_("FireLength", this.fireLength);
        tag.m_128379_("IgnoresInvulTime", this.ignoresInvulTime);
        tag.m_128405_("DespawnTime", this.despawnTime);
        tag.m_128379_("Glows", this.glows);
        tag.m_128379_("Griefing", this.griefing);
        tag.m_128379_("GriefingDropsBlocks", this.griefingDropsBlocks);
        tag.m_128379_("FireGriefing", this.fireGriefing);
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setHasBrokenBlock(tag.m_128471_("HasBrokenBlock"));
        this.setIsRodling(tag.m_128471_("IsRodling"));
        this.setHasShields(tag.m_128471_("HasShields"));
        this.setHasArmour(tag.m_128471_("HasArmour"));
        this.setCollectable(tag.m_128471_("Collectable"));
        this.damage = tag.m_128457_("Damage");
        this.fireLength = tag.m_128451_("FireLength");
        this.ignoresInvulTime = tag.m_128471_("IgnoresInvulTime");
        this.despawnTime = tag.m_128451_("DespawnTime");
        this.glows = tag.m_128471_("Glows");
        this.griefing = tag.m_128471_("Griefing");
        this.griefingDropsBlocks = tag.m_128471_("GriefingDropsBlocks");
        this.fireGriefing = tag.m_128471_("FireGriefing");
    }

    public boolean hasBrokenBlock() {
        return (Boolean)this.f_19804_.m_135370_(BROKEN_BLOCK);
    }

    public void setHasBrokenBlock(boolean setTo) {
        this.f_19804_.m_135381_(BROKEN_BLOCK, (Object)setTo);
    }

    public boolean isRodling() {
        return (Boolean)this.f_19804_.m_135370_(RODLING);
    }

    public void setIsRodling(boolean setTo) {
        this.f_19804_.m_135381_(RODLING, (Object)setTo);
    }

    public boolean hasShields() {
        return (Boolean)this.f_19804_.m_135370_(SHIELDS);
    }

    public void setHasShields(boolean setTo) {
        this.f_19804_.m_135381_(SHIELDS, (Object)setTo);
    }

    public boolean hasArmour() {
        return (Boolean)this.f_19804_.m_135370_(ARMOUR);
    }

    public void setHasArmour(boolean setTo) {
        this.f_19804_.m_135381_(ARMOUR, (Object)setTo);
    }

    public boolean isCollectable() {
        return (Boolean)this.f_19804_.m_135370_(COLLECTABLE);
    }

    public void setCollectable(boolean setTo) {
        this.f_19804_.m_135381_(COLLECTABLE, (Object)setTo);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

